local assets=
{ 
    Asset("ANIM", "anim/ricards_rapier.zip"),
    Asset("ANIM", "anim/ricards_rapier_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/ricards_rapier.xml"),
    
}

local prefabs = 
{
}
local newdmgmult


local function StatBoost(inst, data)
    local percent = inst.components.health:GetPercent()
    inst.components.combat.damagemultiplier = inst.components.combat.damagemultiplier - newdmgmult --very first time it is the character dmgmult. without anything it is 0.9
    if (percent < 0.25) then
        newdmgmult = 0.40
    elseif (percent < 0.40) then
        newdmgmult = 0.25
    elseif (percent < 0.50) then
        newdmgmult = 0.10
    elseif (percent < 0.75) then -- Less than 75%
        newdmgmult = 0.05
    else 
        newdmgmult = 0.00
    end
    inst.components.combat.damagemultiplier = inst.components.combat.damagemultiplier + newdmgmult --if it was >0.95 then now dmgmult=0.9+0.00
end

local function fn(colour)

    local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "ricards_rapier_swap", "ricards_rapier_swap")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
        newdmgmult=0;
        owner:ListenForEvent("hungerdelta", StatBoost)

    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
		owner:RemoveEventCallback("hungerdelta", StatBoost)
		owner.components.combat.damagemultiplier = owner.components.combat.damagemultiplier - newdmgmult
    end
	
	local function onfinished(inst)
		inst:Remove()
	end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("ricards_rapier")
    anim:SetBuild("ricards_rapier")
    anim:PlayAnimation("idle")

    inst:AddComponent("inventoryitem")
	--(DST)inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "ricards_rapier"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/ricards_rapier.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	--(DST)inst.components.inventoryitem.keepondeath = true
	
	inst:AddComponent("inspectable")
	
	inst:AddTag("sword")
	inst:AddTag("blade")
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(75)
	inst.components.weapon:SetRange(0.2, 0.2)
	--inst.components.weapon:SetOnAttack(OnAttack)
	

	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150) 
    inst.components.finiteuses:SetOnFinished( onfinished )
	
    return inst
end

return  Prefab("common/inventory/ricards_rapier", fn, assets, prefabs)